/*************************************************

audiocap.c
used by tw686x

**************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>		/* low-level i/o */
#include <unistd.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <linux/soundcard.h>
#include "tw686x.h"
#include "gui.h"
#include "audiocap.h"

int
audio_play_close (gui_t * gui)
{
    if (-1 == close (gui->aud_play_fd))
        return -1;
    gui->aud_play_fd = -1;

    return 1;
}

int
audio_play_open (gui_t *gui)
{
    struct stat st;
    int tmp;
    char dev_name[MAX_NAME_LEN];

    gui->aud_play_fd = -1;
    memset (dev_name, 0, MAX_NAME_LEN);
    sprintf (dev_name, "/dev/dsp");

    if (-1 == stat (dev_name, &st))
    {
        return -1;
    }
    if (!S_ISCHR (st.st_mode))
    {
        return -1;
    }
    gui->aud_play_fd = open (dev_name, O_RDWR /*  required */ , 0);
    if (-1 == gui->aud_play_fd)
    {
        return -1;
    }

    tmp = 8;
    if( -1 == ioctl(gui->aud_play_fd, SOUND_PCM_WRITE_BITS, &tmp)) {
        return -1;
    }

    tmp = 8000;
    if( -1 == ioctl(gui->aud_play_fd, SOUND_PCM_WRITE_RATE, &tmp)) {
        return -1;
    }

    tmp = 1;
    if( -1 == ioctl(gui->aud_play_fd, SOUND_PCM_WRITE_CHANNELS, &tmp)) {
        return -1;
    }

    return 1;
}

int
audio_device_close (channel_t * chl)
{
    if (-1 == close (chl->dev_audio.fd))
        return -1;
    chl->dev_audio.fd = -1;

    return 1;
}

int
audio_device_open (channel_t * chl)
{
    struct stat st;

    chl->dev_audio.fd = -1;
    memset (chl->dev_audio.dev_name, 0, MAX_NAME_LEN);
    sprintf (chl->dev_audio.dev_name, "/dev/dsp%d", chl->id+1);

    if (-1 == stat (chl->dev_audio.dev_name, &st))
    {
        return -1;
    }
    if (!S_ISCHR (st.st_mode))
    {
        return -1;
    }
    chl->dev_audio.fd = open (chl->dev_audio.dev_name, O_RDWR | O_NONBLOCK /*  required */ , 0);
    if (-1 == chl->dev_audio.fd)
    {
        return -1;
    }

    chl->audio_opened = TRUE;

    return 1;
}

int audio_device_setfmt(channel_t *chl)
{
    if( -1 == ioctl(chl->dev_audio.fd, SNDCTL_DSP_SETFMT, &chl->audio_bits)) {
        return -1;
    }

    if( -1 == ioctl(chl->dev_audio.fd, SNDCTL_DSP_SPEED, &chl->audio_samplerate)) {
        return -1;
    }

    if( -1 == ioctl(chl->dev_audio.fd, SNDCTL_DSP_CHANNELS, &chl->audio_channels)) {
        return -1;
    }

    return 0;
}

int wav_open(wav_file_t *wav)
{
    typedef struct {
        unsigned short  wFormatTag;
        unsigned short  nChannels;
        unsigned long   nSamplesPerSec;
        unsigned long   nAvgBytesPerSec;
        unsigned short  nBlockAlign;
        unsigned short  wBitsPerSample;
        unsigned short  cbSize;
    } WAVEFORMATEX;

    unsigned long dwWrite=0, dwData=0;

    if(wav->fd != -1) {
        return wav->fd;
    }

	wav->fd = open(wav->name, O_RDWR|O_CREAT, 0600);
	if(wav->fd == -1) {
	    return -1;
	}

    dwWrite = write( wav->fd, "RIFF", 4 );		//0
    dwWrite = write( wav->fd, &dwData, 4 );		//4	  file len
    dwWrite = write( wav->fd, "WAVEfmt ", 8 );	//8
    dwData  = 18;//sizeof(WAVEFORMATEX);
    dwWrite = write( wav->fd, &dwData, 4 );		//16
    dwData  = 1;
    dwWrite = write( wav->fd, &dwData, 2 );		//20
    dwData  = wav->channels;
    dwWrite = write( wav->fd, &dwData, 2 );		//22
    dwData  = wav->sample_rate;
    dwWrite = write( wav->fd, &dwData, 4 );		//24
    dwData  = wav->bits * wav->channels * wav->sample_rate / 8;
    dwWrite = write( wav->fd, &dwData, 4 );		//28
    dwData  = wav->bits * wav->channels / 8;
    dwWrite = write( wav->fd, &dwData, 2 );		//32
    dwData  = wav->bits;
    dwWrite = write( wav->fd, &dwData, 2 );		//34
    dwWrite = write( wav->fd, &dwData, 2 );		//36
    dwWrite = write( wav->fd, "data", 4 );		//48
    dwWrite = write( wav->fd, &dwData, 4 );		//42  data len

    return wav->fd;
}

int wav_write(wav_file_t *wav, unsigned char *data, int length)
{
	int dwWrite = 0;

	if(wav->fd > -1) {
		dwWrite = write(wav->fd, data, length);
		wav->length += dwWrite;
	}

	return dwWrite;
}

int wav_close(wav_file_t *wav)
{
    unsigned long dwFileLen = wav->length + 38;
    unsigned long dwWrite = 0;

    if(wav->fd != -1) {
        lseek(wav->fd, 4, SEEK_SET);
        dwWrite = write( wav->fd, &dwFileLen, 4 );
        lseek(wav->fd, 42, SEEK_SET);
        dwWrite = write( wav->fd, &wav->length, 4 );
        close(wav->fd);
        wav->fd = -1;
    }

    return 0;
}
