#ifndef NETBROADCASTERDLG_H
#define NETBROADCASTERDLG_H

#include <QWidget>
#include <QtGui>
#include <QtCore>

namespace Ui {
class NetBroadcasterDlg;
}

class NetBroadcasterDlg : public QWidget
{
    Q_OBJECT

public:
    explicit NetBroadcasterDlg(QWidget *parent = 0);
    ~NetBroadcasterDlg();

    void HwInitialize();

    void HwUninitialize();

public:
    Ui::NetBroadcasterDlg *ui;

public:
    PVOID				m_pDevice;

    PVOID				m_hNetworkServer;

    volatile ULONG		m_nNetworkServerState_audio;

    CRITICAL_SECTION	m_hNetworkServerAccessCriticalSection_audio;

    volatile ULONG		m_nNetworkServerState_video;

    CRITICAL_SECTION	m_hNetworkServerAccessCriticalSection_video;

    ULONG				m_nVideoWidth;

    ULONG				m_nVideoHeight;

    BOOL				m_bVideoIsInterleaved;

    double				m_dVideoFrameRate;

    ULONG				m_nAudioChannels;

    ULONG				m_nAudioBitsPerSample;

    ULONG				m_nAudioSampleFrequency;

private slots:
    void on_pushBTN_StartRTSP_clicked();

    void on_pushBTN_StopRTSP_clicked();
};

#endif // NETBROADCASTERDLG_H
