//**********************************************************************//
//**                                                                  **//
//**              (C)Copyright 1985-2015, Jetway Co.,Ltd              **//
//**                                                                  **//
//**                       All Rights Reserved.                       **//
//**********************************************************************//
//**********************************************************************
// Name:  F9HBPL.c
//
// Description: main file.
//
//**********************************************************************

//#include <unistd.h>  /* UNIX GCC USE*/
//#include <termios.h> /* UNIX GCC USE*/
#include <stdio.h>   
#include <string.h>  
#include <fcntl.h>   
#include <errno.h>   
#include <stdlib.h>
#include "common.h"

int CheckFintekChipId();

//void Error_Message(int status);
int Help_Message(void);
int print_parameters_message(void);
int print_onblan_help(void);
int print_etb4g_help(void);

int CheckFintekChipId(void);
int Switch_Reset_WDT(void);
int Switch_Bypass_WDT(void);
int onblan_control(int argc, char *argv[]);
int etb4g_control(int argc, char *argv[]);
int GetSuperIO (int LDN, int iPort);
int SetSuperIO (int LDN, int iPort, int iData);
int GetSIOGPIO (int GPIONO);
int SetSIOGPIO (int GPIONO, int Value8);


int main(int argc, char *argv[])
{
	int	status = ERROR_BAD;	//Default error.

if (CheckFintekChipId()) // Check Fintek ChipId
		{
			printf("\nTools Can't Run On This Platform.\n");
			exit (1);
		}
if ((!strcmp(argv[1], "-h")||(!strcmp(argv[1], "?")) || (!strcmp(argv[1], "h"))))	//Help information
   {
	Help_Message();
	exit (0);
   }

	if (argc > 1)
	{
		if ((strcmp(argv[1], "-n1")) == 0) //Onboard
			status = onblan_control(argc, argv);
		else if ((strcmp(argv[1], "-n2")) == 0)	//Etb4g
			status = etb4g_control(argc, argv);
	else
	    {
	      Help_Message();
	      print_parameters_message();
	      exit(0);
	    }
	}
	if (status == ERROR_BAD)		//Error information
	    {
	    Help_Message();
	    exit(0);
	    }
	    if (status == ERROR_BAD_ONBOARD)		//Error information
	    {
			   print_onblan_help();			//Display help information
			   print_parameters_message();
			   exit(1);
	    }
	    if (status == ERROR_BAD_ETB4G)		//Error information
	    {
			   print_etb4g_help();			//Display help information
			   print_parameters_message();
			   exit(1);
	    }

	return	status;
}

//----------------------------------------------------------------------------
// Procedure:   onblan_control
//
// Description: control Onboard lan bypass function
//
// Input:       int argc - Main argc
//              char *argv[] - Main *argv[]
//
// Output:      int - Error status
//
// Notes:
//----------------------------------------------------------------------------
int onblan_control(int argc, char *argv[])
{
	int status = ERROR_BAD_ONBOARD;	//Default stauts : error
  int time_value,Value8;
	if (argc > 1)
	{
	  if ((strcmp(argv[2], "-s1")) == 0)   //lan 1/2
	    {
	     if ((strcmp(argv[3], "-b")) == 0)
	       {
		 Switch_Reset_WDT();
		 SetSIOGPIO(5, 0);
		 printf("\nSet Onboard LAN1_LAN2");
		 textcolor(10); //GREEN
		 cprintf(" Bypass ");
		 textcolor(7);
		 cprintf("Mode\n");
		 status = ERROR_OK;
		 //bypass
		}
	      else if ((strcmp(argv[3], "-p")) == 0)
	       {
		Switch_Reset_WDT();
		SetSIOGPIO(5, 1);
		printf("\nSet Onboard LAN1_LAN2");
		textcolor(10); //GREEN
		cprintf(" Passthrough ");
		textcolor(7);
		cprintf("Mode\n");
		status = ERROR_OK;
	       }
	     else if ((strcmp(argv[3], "-w")) == 0)
	       {
	       if (argc > 4) //must have 5 parameters
		{
		 time_value = atoi(argv[4]);
		  if ((time_value >= 10) &&(time_value <= 255))
		     {

			if ((strcmp(argv[5], "min")) == 0)
			  {
			  Switch_Bypass_WDT();
			  SetSuperIO(0x07, 0xF6, time_value);

			  Value8 = GetSuperIO(0x07, 0xFA);
			  Value8 |= 0x01;
			  SetSuperIO(0x07, 0xFA, Value8);

			  Value8 = GetSuperIO(0x07, 0xF5);
			  Value8 &= ~0x28;
			  Value8 |= 0x29; //set min,width and count down.
			  SetSuperIO(0x07, 0xF5, Value8);

			  printf("\nSet Onboard LAN1_LAN2 WatchDog for ");
			  textcolor(10); //GREEN
			  cprintf(argv[4]);
			  textcolor(7);
			  cprintf(" Minute\n");
			  status = ERROR_OK;
		       }
		      else if  ((strcmp(argv[5], "sec")) == 0)
		       {
			 Switch_Bypass_WDT();
			 SetSuperIO(0x07, 0xF6, time_value);

			 Value8 = GetSuperIO(0x07, 0xFA);
			 Value8 |= 0x01;
			 SetSuperIO(0x07, 0xFA, Value8);

			 Value8 = GetSuperIO(0x07, 0xF5);
			 Value8 &= ~0x28;
			 Value8 |= 0x21; //set width and enable count
			 SetSuperIO(0x07, 0xF5, Value8);

			 printf("\nSet Onboard LAN1_LAN2 WatchDog for ");
			 textcolor(10); //GREEN
			 cprintf(argv[4]);
			 textcolor(7);
			 cprintf(" Second\n");
			 status = ERROR_OK;
			    }
		 }
	     }
	  }
	 }
   }
	return status;
}

//----------------------------------------------------------------------------
// Procedure:   etb4g_control
//
// Description: control etb4g card bypass function
//
// Input:       int argc - Main argc
//              char *argv[] - Main *argv[]
//
// Output:      int - Error status
//
// Notes:
//----------------------------------------------------------------------------
int etb4g_control(int argc, char *argv[])
{
	int status = ERROR_BAD_ETB4G;	//Default stauts : error

	if (argc > 1)
	{
		if ((strcmp(argv[2], "-s1")) == 0)		//lan 1/2
		{
			if ((strcmp(argv[3], "-b")) == 0)
			   {
				SetSIOGPIO(6, 1); //By Pass mode
				  printf("\nSet ETB4G LAN1_LAN2");
				  textcolor(10); //GREEN
				  cprintf(" Bypass ");
				  textcolor(7);
				  cprintf("Mode\n");
				  status = ERROR_OK;
				 }
			else if ((strcmp(argv[3], "-p")) == 0)
			   {
				  SetSIOGPIO(6, 0); //Pass Through mode
				  printf("\nSet ETB4G LAN1_LAN2");
				  textcolor(10); //GREEN
				  cprintf(" Passthrough ");
				  textcolor(7);
				  cprintf("Mode\n");
				  status = ERROR_OK;
				 }
		}
		else if ((strcmp(argv[2], "-s2")) == 0)	//lan 3/4
		{
			if ((strcmp(argv[3], "-b")) == 0)
			   {
				SetSIOGPIO(4, 1); //By Pass mode
				printf("\nSet ETB4G LAN3_LAN4");
				  textcolor(10); //GREEN
				  cprintf(" Bypass ");
				  textcolor(7);
				  cprintf("Mode\n");
				  status = ERROR_OK;
				 }
			else if ((strcmp(argv[3], "-p")) == 0)		//
			   {
				  SetSIOGPIO(4, 0); //Pass Through mode
				  printf("\nSet ETB4G LAN3_LAN4");
				  textcolor(10); //GREEN
				  cprintf(" Passthrough ");
				  textcolor(7);
				  cprintf("Mode\n");
				  status = ERROR_OK;
				 }
		}
	 }
      return status;
}

int CheckFintekChipId(void)
{
	unsigned long int ulRdId;

	ulRdId = GetSuperIO(0x6,0x21);
	ulRdId = (((ulRdId << 8) & 0xFF00) | GetSuperIO(0x6,0x20));
	   if (ulRdId != 0x1012) // 0:the same
	      {
		outportb(0x2E, SIO_CONFIG_MODE_ENTER_VALUE);
		outportb(0x2E, SIO_CONFIG_MODE_ENTER_VALUE);
		outportb(0x2E, 0x21);
		ulRdId = inportb(0x2F);
		outportb(0x2E, 0x20);
		ulRdId = (((ulRdId << 8) & 0xFF00) | inportb(0x2F));
		outportb(0x2E, SIO_CONFIG_MODE_EXIT_VALUE);
		if (ulRdId != 0x1012) // 0:the same
		{
			return 1;
		}
	      }
	return 0;
}
//----------------------------------------------------------------------------
// Procedure:   Switch_Reset_WDT
//
// Description: Switch WatchDog To Reset Mode Setting.
//
// Input:
//
// Output:
//
// Notes:
//----------------------------------------------------------------------------
int Switch_Reset_WDT(void)
{
     int Value8;

     Value8 = GetSuperIO(0x7, 0xF5);
     Value8 |= 0x10; //switch wdt to pluse mode AND CLEAR WDT STATUS.
     SetSuperIO(0x7,  0xF5, Value8);

     Value8 = GetSuperIO(0x0A, 0x28);
     Value8 |= 0x20;
     SetSuperIO(0x0A, 0x28, Value8); //GPIO05 SWITCH TO GPIO

     Value8 = GetSuperIO(0x0A, 0x29);
     Value8 &= ~(0x10); //SET GPIO14 TO WDT, RETURN RESET FUNCTION
     SetSuperIO(0x0A, 0x29, Value8);

     return 0;
}
//----------------------------------------------------------------------------
// Procedure:   Switch_Bypass_WDT
//
// Description: Switch WatchDog To Bypass Mode Setting.
//
// Input:
//
// Output:
//
// Notes:
//----------------------------------------------------------------------------
int Switch_Bypass_WDT(void)
{
     int Value8;
      SetSIOGPIO(5, 1); //set Default passthrough Mode default.

      Value8 = GetSuperIO(0x0A, 0x28);
      Value8 &= ~(0x20);
      SetSuperIO(0x0A, 0x28, Value8); //GPIO05 SWITCH TO WDT

      Value8 = GetSuperIO(0x0A, 0x29);
      Value8 |= 0x10; //SET GPIO14 TO GPIO, REMOVE RESET FUNCTION
      SetSuperIO(0x0A, 0x29, Value8);

      Value8 = GetSuperIO(0x07, 0xF5);
      Value8 &= ~(0x10); //SWITCH WDT TO LEVEL MODE
      SetSuperIO(0x07, 0xF5, Value8);
     return 0;
}
//----------------------------------------------------------------------------
// Procedure:   Help_Message
//
// Description: Display help information.
//
// Input:
//
// Output:
//
// Notes:
//----------------------------------------------------------------------------
int Help_Message(void)
{

   printf("   +------------------------------------------------------------------------+");
   printf("\n   |              NF9HB LAN Pair Bypass Control Utility V0.02               |");
   printf("\n   |    Copyright(c)2015 Jetway information co., LTD, ALL Right Reserved    |");
   printf("\n   + ---------------------------------------------------------------------- +");
   printf("\n   | Usage: Filaname <Command1> <Command2> <Command3> <Command4> <Command5> |");
   printf("\n   + ---------------------------------------------------------------------- +");
   printf("\n   | Command1:                                                              |");
   printf("\n   |         -n1    : Onboard Control                                       |");
   printf("\n   |         -n2    : ETB4G Extend Lan Control                              |");
   printf("\n   |         -h     : Help Message                                          |");
   printf("\n   | Command2:                                                              |");
   printf("\n   |         -s[x]  : Select Lan Pair, s1(Lan1/Lan2)/s2(Lan3/Lan4)          |");
   printf("\n   | Command3:                                                              |");
   printf("\n   |         -b     : Set Bypass Mode                                       |");
   printf("\n   |         -p     : Set Passthrough Mode                                  |");
   printf("\n   |         -w     : Set WatchDog Bypass Mode (Onboard Lan Only)           |");
   printf("\n   | Command4:                                                              |");
   printf("\n   |          [y]   : Set WatchDog Bypass Mode, y = 10~255                  |");
   printf("\n   | Command5:                                                              |");
   printf("\n   |          min   : Set WatchDog Count by Minute                          |");
   printf("\n   |          sec   : Set WatchDog Count by second                          |");
   printf("\n   + ---------------------------------------------------------------------- +\n");
   system("pause");
   printf("\n   + ---------------------------------------------------------------------- +");
   printf("\n   | Example:                                                               |");
   printf("\n   | Filename -n1 -s1 -b : Set Onboard LAN3_LAN4 Bypass Mode                |");
   printf("\n   | Filename -n2 -s1 -p : Set ETB4G   LAN1_LAN2 PassThrough Mode           |");
   printf("\n   | Filename -n1 -s1 -w 20 min                                             |");
   printf("\n   |        Enable Onboard LAN1_LAN2 Bypass WatchDog Function,Set 20 Minutes|");
   printf("\n   +------------------------------------------------------------------------+");
   printf("\n");
   return 0;
}
//----------------------------------------------------------------------------
// Procedure:   onboardlan_Message
//
// Description: Display help information.
//
// Input:
//
// Output:
//
// Notes:
//----------------------------------------------------------------------------
int print_onblan_help()
{
   printf("   +------------------------------------------------------------------------+");
   printf("\n   |                   Onboard LAN Bypass function                          |");
   printf("\n   + ---------------------------------------------------------------------- +");
   printf("\n   | Usage: Filaname <Command1> <Command2> <Command3> <Command4> <Command5> |");
   printf("\n   + ---------------------------------------------------------------------- +");
   printf("\n   | Command1:                                                              |");
   printf("\n   |         -n1    : Onboard Control                                       |");
   printf("\n   |         -h     : Help Message                                          |");
   printf("\n   | Command2:                                                              |");
   printf("\n   |         -s1    : Select Lan Pair, s1(LAN3_LAN4)                        |");
   printf("\n   | Command3:                                                              |");
   printf("\n   |         -b     : Set Bypass Mode                                       |");
   printf("\n   |         -p     : Set Passthrough Mode                                  |");
   printf("\n   |         -w     : Set WatchDog Bypass Mode                              |");
   printf("\n   | Command4:                                                              |");
   printf("\n   |          [y]   : Set WatchDog Bypass Mode, y = 10~255                  |");
   printf("\n   | Command5:                                                              |");
   printf("\n   |          min   : Set WatchDog Count by Minute                          |");
   printf("\n   |          sec   : Set WatchDog Count by second                          |");
   printf("\n   + ---------------------------------------------------------------------- +");
   printf("\n   | Example:                                                               |");
   printf("\n   | Filename -n1 -s1 -b : Set Onboard LAN1_LAN2 Bypass Mode                |");
   printf("\n   | Filename -n1 -s1 -p : Set Onboard LAN1_LAN2 PassThrough Mode           |");
   printf("\n   | Filename -n1 -s1 -w 20 min                                             |");
   printf("\n   |        Enable Onboard LAN1_LAN2 Bypass WatchDog Function,Set 20 Minutes|");
   printf("\n   +------------------------------------------------------------------------+");
   printf("\n");
  return 0;
}
//----------------------------------------------------------------------------
// Procedure:   etb4g_Message
//
// Description: Display help information.
//
// Input:
//
// Output:
//
// Notes:
//----------------------------------------------------------------------------
int print_etb4g_help(void)
{
   printf("   +------------------------------------------------------------------------+");
   printf("\n   |                    ETB4G LAN Bypass function                           |");
   printf("\n   + ---------------------------------------------------------------------- +");
   printf("\n   | Usage: Filaname <Command1> <Command2> <Command3>                       |");
   printf("\n   + ---------------------------------------------------------------------- +");
   printf("\n   | Command1:                                                              |");
   printf("\n   |         -n2    : Onboard Control                                       |");
   printf("\n   |         -h     : Help Message                                          |");
   printf("\n   | Command2:                                                              |");
   printf("\n   |         -s[x]  : Select Lan Pair, s1(LAN1_LAN2)/s2(LAN3_LAN4)          |");
   printf("\n   | Command3:                                                              |");
   printf("\n   |         -b     : Set Bypass Mode                                       |");
   printf("\n   |         -p     : Set Passthrough Mode                                  |");
   printf("\n   + ---------------------------------------------------------------------- +");
   printf("\n   | Example:                                                               |");
   printf("\n   | Filename -n2 -s1 -b : Set ETB4G LAN1_LAN2 Bypass Mode                  |");
   printf("\n   | Filename -n2 -s2 -p : Set ETB4G LAN3_LAN4 PassThrough Mode             |");
   printf("\n   +------------------------------------------------------------------------+");
   printf("\n");
   return 0;
}


int print_parameters_message(void)
{
   textcolor(15); //
   cprintf("\nWrong parameters, Please Check Command.");
   textcolor(7); //
   cprintf("\n");
  return 0;
}
//----------------------------------------------------------------------------
// Procedure:   SetSuperIO
//
// Description: Set SuperIO LDN register Value.
//
// Input:      int LDN   : IO LDN Device
//             int iPort : Index Device Register
//             int iData : Index Device Data
// Output:
//
// Notes:
//----------------------------------------------------------------------------
int SetSuperIO (int LDN,int iPort,int iData)
{
	outportb(SIO_CONFIG_INDEX, SIO_CONFIG_MODE_ENTER_VALUE);
	outportb(SIO_CONFIG_INDEX, SIO_CONFIG_MODE_ENTER_VALUE);
	outportb(SIO_CONFIG_INDEX, 0x07);
	outportb(SIO_CONFIG_DATA, LDN);
	outportb(SIO_CONFIG_INDEX, iPort);
	outportb(SIO_CONFIG_DATA, iData);
	outportb(SIO_CONFIG_INDEX, SIO_CONFIG_MODE_EXIT_VALUE);
   return 0;
}
//----------------------------------------------------------------------------
// Procedure:   GetSuperIO
//
// Description: Get SuperIO LDN register Value.
//
// Input:      int LDN   : IO LDN Device
//             int iPort : Index Device Register
//             
// Output:     int8 Value. 
//
// Notes:
//----------------------------------------------------------------------------
int GetSuperIO (int LDN,int iPort)
{
	int iRdData;
  outportb(SIO_CONFIG_INDEX, SIO_CONFIG_MODE_ENTER_VALUE);
	outportb(SIO_CONFIG_INDEX, SIO_CONFIG_MODE_ENTER_VALUE);
	outportb(SIO_CONFIG_INDEX, 0x07);
	outportb(SIO_CONFIG_DATA, LDN);
	outportb(SIO_CONFIG_INDEX, iPort);
	iRdData = inportb(SIO_CONFIG_DATA);
	outportb(SIO_CONFIG_INDEX, 0xAA);
	return iRdData;
}


//----------------------------------------------------------------------------
// Procedure:   SetSIOGPIO
//
// Description: Set SuperIO GPIO Pin Output High/Low.
//
// Input:      int GPIONO    : GPIO Pin number
//             int GPIOValue : GPIO Pin High/Low
// Output:      
//
// Notes:
//----------------------------------------------------------------------------
int SetSIOGPIO(int GPIONO,int GPIOValue)
{
	int	Value8;
	if ((GPIONO >= 0) && (GPIONO <= 7))
	{

		Value8 = GetSuperIO(0x06, 0xF1);
		Value8 &= ~(1 << GPIONO);
		if (GPIOValue)
			Value8 |= (1 << GPIONO);
		SetSuperIO(0x06, 0xF1, Value8);
	}

	if ((GPIONO >= 10) && (GPIONO <= 17))
	{

		Value8 = GetSuperIO(0x06, 0xE1);
		Value8 &= ~(1 << (GPIONO - 10));
		if (GPIOValue)
			Value8 |= (1 << (GPIONO - 10));
		SetSuperIO(0x06, 0xE1, Value8);
	}

	if ((GPIONO >= 20) && (GPIONO <= 27))
	{

		Value8 = GetSuperIO(0x06, 0xD1);
		Value8 &= ~(1 << (GPIONO - 20));
		if (GPIOValue)
			Value8 |= (1 << (GPIONO - 20));
		SetSuperIO(0x06, 0xD1, Value8);
	}

	if ((GPIONO >= 30) && (GPIONO <= 37))
	{
		Value8 = GetSuperIO(0x06, 0xC1);
		Value8 &= ~(1 << (GPIONO - 30));
		if (GPIOValue)
			Value8 |= (1 << (GPIONO - 30));
		SetSuperIO(0x06, 0xC1, Value8);
	}

	if ((GPIONO >= 40) && (GPIONO <= 47))
	{
		Value8 = GetSuperIO(0x06, 0xB1);
		Value8 &= ~(1 << (GPIONO - 40));
		if (GPIOValue)
			Value8 |= (1 << (GPIONO - 40));
		SetSuperIO(0x06, 0xB1, Value8);
	}

	if ((GPIONO >= 50) && (GPIONO <= 57))
	{
		Value8 = GetSuperIO(0x06, 0xA1);
		Value8 &= ~(1 << (GPIONO - 50));
		if (GPIOValue)
			Value8 |= (1 << (GPIONO - 50));
		SetSuperIO(0x06, 0xA1, Value8);
	}

	if ((GPIONO >= 60) && (GPIONO <= 67))
	{

		Value8 = GetSuperIO(0x06, 0x91);
		Value8 &= ~(1 << (GPIONO - 60));
		if (GPIOValue)
			Value8 |= (1 << (GPIONO - 60));
		SetSuperIO(0x06, 0x91, Value8);
	}

	if ((GPIONO >= 70) && (GPIONO <= 77))
	{

		Value8 = GetSuperIO(0x06, 0x81);
		Value8 &= ~(1 << (GPIONO - 70));
		if (GPIOValue)
			Value8 |= (1 << (GPIONO - 70));
		SetSuperIO(0x06, 0x81, Value8);
	}
     return 0;
}



//----------------------------------------------------------------------------
// Procedure:   GetSIOGPIO
//
// Description: Get SuperIO GPIO Pin Value.
//
// Input:      int GPIONO    : GPIO Pin number
//
// Output:     TRUE  : 1
//             FALSE : 0
// Notes:
//----------------------------------------------------------------------------
int GetSIOGPIO (int GPIONO)
{
	int	Value8;
	if ((GPIONO >= 0) && (GPIONO <= 7))
	{
		Value8 = GetSuperIO(0x06, 0xF0);
		Value8 &= ~(1 << GPIONO);
		SetSuperIO(0x06, 0xF0, Value8);
	
		Value8 = GetSuperIO(0x06, 0xF1);
		Value8 &= (1 << GPIONO);

		if (Value8)
		    return TRUE;
		else
		    return FALSE;
	}
	if ((GPIONO >= 10) && (GPIONO <= 17))
	{
		Value8 = GetSuperIO(0x06, 0xE0);
		Value8 &= ~(1 << (GPIONO - 10));
		SetSuperIO(0x06, 0xE0, Value8);
	
		Value8 = GetSuperIO(0x06, 0xE1);
		Value8 &= (1 << (GPIONO - 10));

		if (Value8)
		    return TRUE;
		else
		    return FALSE;
	}
	if ((GPIONO >= 20) && (GPIONO <= 27))
	{
		Value8 = GetSuperIO(0x06, 0xD0);
		Value8 &= ~(1 << (GPIONO - 20));
		SetSuperIO(0x06, 0xD0, Value8);
	
		Value8 = GetSuperIO(0x06, 0xD1);
		Value8 &= (1 << (GPIONO - 20));

		if (Value8)
		    return TRUE;
		else
		    return FALSE;
	}
	if ((GPIONO >= 30) && (GPIONO <= 37))
	{
		Value8 = GetSuperIO(0x06, 0xC0);
		Value8 &= ~(1 << (GPIONO - 30));
		SetSuperIO(0x06, 0xC0, Value8);
	
		Value8 = GetSuperIO(0x06, 0xC1);
		Value8 &= (1 << (GPIONO - 30));

		if (Value8)
		    return TRUE;
		else
		    return FALSE;
	}
	if ((GPIONO >= 40) && (GPIONO <= 47))
	{
		Value8 = GetSuperIO(0x06, 0xB0);
		Value8 &= ~(1 << (GPIONO - 40));
		SetSuperIO(0x06, 0xB0, Value8);

		Value8 = GetSuperIO(0x06, 0xB1);
		Value8 &= (1 << (GPIONO - 40));

		if (Value8)
		    return TRUE;
		else
		    return FALSE;
	}
	if ((GPIONO >= 50) && (GPIONO <= 57))
	{
		Value8 = GetSuperIO(0x06, 0xA0);
		Value8 &= ~(1 << (GPIONO - 50));
		SetSuperIO(0x06, 0xA0, Value8);
	
		Value8 = GetSuperIO(0x06, 0xA1);
		Value8 &= (1 << (GPIONO - 50));

		if (Value8)
		    return TRUE;
		else
		    return FALSE;
	}
	if ((GPIONO >= 60) && (GPIONO <= 67))
	{
		Value8 = GetSuperIO(0x06, 0x90);
		Value8 &= ~(1 << (GPIONO - 60));
		SetSuperIO(0x06, 0x90, Value8);
	
		Value8 = GetSuperIO(0x06, 0x91);
		Value8 &= (1 << (GPIONO - 60));

		if (Value8)
		    return TRUE;
		else
		    return FALSE;
	}
	if ((GPIONO >= 70) && (GPIONO <= 77))
	{
		Value8 = GetSuperIO(0x06, 0x80);
		Value8 &= ~(1 << (GPIONO - 70));
		SetSuperIO(0x06, 0x80, Value8);
	
		Value8 = GetSuperIO(0x06, 0x81);
		Value8 &= (1 << (GPIONO - 70));

		if (Value8)
		    return TRUE;
		else
		    return FALSE;
	}
	return	FALSE;
}