// HIDDcDcUsb.cpp: implementation of the HIDDcDcUsb class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "HIDDcDcUsb.h"
#include "HIDDevice.h"
#include "HIDDescriptor.h"
#include "HIDGraphics.h"
#include <math.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#define A_SLEEP			5      
#define A_TIMEOUT		3000
#define BUF_LINE_LEN	47
#define STR_LINE_LEN	57

#define PKG_LEN_LCD		64
#define PKG_LEN_FLASH	37

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
ATXMSG g_memMessages[MAX_MESSAGE_CNT] = 
{
	{52, 1, _T("Voltage 0")							, true, 7, 0		, _T("Set Output Voltage 0. Changes will take effect after a power cycle."), _T("[V]") },
	{53, 1, _T("Voltage 1")							, true, 7, 0		, _T("Set Output Voltage 1. Changes will take effect after a power cycle."), _T("[V]") },
	{54, 1, _T("Voltage 2")							, true, 7, 0		, _T("Set Output Voltage 2. Changes will take effect after a power cycle."), _T("[V]") },
	{55, 1, _T("Voltage 3")							, true, 7, 0		, _T("Set Output Voltage 3. Changes will take effect after a power cycle."), _T("[V]") },
	{56, 1, _T("Voltage 4")							, true, 7, 0		, _T("Set Output Voltage 4. Changes will take effect after a power cycle."), _T("[V]") },
	{57, 1, _T("Voltage 5")							, true, 7, 0		, _T("Set Output Voltage 5. Changes will take effect after a power cycle."), _T("[V]") },
	{58, 1, _T("Voltage 6")							, true, 7, 0		, _T("Set Output Voltage 6. Changes will take effect after a power cycle."), _T("[V]") },
	{59, 1, _T("Voltage 7")							, true, 7, 0		, _T("Set Output Voltage 7. Changes will take effect after a power cycle."), _T("[V]") },

	{ 0, 1, _T("Ignition HIGH limit")				, true, 2, 0.1558	, _T("Above this voltage IGN is considered ON"), _T("[V]") },
	{ 1, 1, _T("Ignition LOW limit")				, true, 2, 0.1558	, _T("Below this voltage IGN is considered OFF"), _T("[V]") },
	{ 2, 1, _T("Ignition Debounce")					, false,1, 10		, _T("Ignition filter de-bouncing"), _T("[ms]") },
	
	{30, 1, _T("Automotive Mode: Ignition Cancel Time")	, true, 1, 1		, _T("After DCDC-USB \"boots\" in AUTOMOTIVE mode IGN is cancelled for this time"), _T("[sec]") },
	{14, 1, _T("Automotive Mode: Thump timeout")		, true, 1, 1		, _T("THUMP timeout, switching off the audio amplifier during motherboard startup/shutdown"), _T("[sec]") },
	
	{ 3, 1, _T("Delay before PSU startup")			, true, 1, 1		, _T("Initial startup delay to avoid re-cranking problems"), _T("[s]") },
	{ 4, 1, _T("Min. VIN voltage at startup")		, true, 2, 0.1558	, _T("Input voltage STARTUP ZONE treshold "), _T("[V]") },
	{ 5, 1, _T("Min. VIN voltage while running")	, true, 2, 0.1558	, _T("Input voltage RUNNING ZONE treshold "), _T("[V]") },
	{ 6, 1, _T("Max. allowed VIN voltage")			, false,2, 0.1558	, _T("Input voltage, HIGH SHUTDOWN treshold [35V]"), _T("[V]") },
	
	{63, 1, _T("Min. VIN voltage deep discharge")	, true, 2, 0.1558	, _T("Minimum VIN voltage measured during off delay"), _T("[V]") },

//	{ 7, 1, _T("Max. limit for Voltage")			, true, 2, 0.1558	, _T("MAX voltage treshold"), _T("[V]") },
//	{ 8, 1, _T("Min. limit for Voltage")			, true, 2, 0.1558	, _T("MIN voltage treshold"), _T("[V]") },
	{ 9, 1, _T("Regulator offset")					, true, 1, 1		, _T("Regulator offset (firmware version >= v2.0)"), _T("") },
	{10, 2, _T("PSW \"push-down\" time")			, true, 1, 10		, _T("How long the PSW button is pressed down"), _T("[ms]") },
			//{11, 0, _T("FILLER")							, true, 1, 1		, _T(""), _T("") },
//	{ 12, 1, _T("Emergency timeout")				, true, 1, 1					, _T("Delay"), _T("[s]") },
	{13, 1, _T("Configuration flags")				, true, 9, 1		, _T("Configuration flags: bit0=Regulator Enabled/Disabled(v2.0+)\nbit1=Power cycle On/Off(v2.1+)\nbit2=On pulse enable/disable bit3=Off pulse enable/disable(v3.1+)\nbit4=USB sense enable/disable(v4.0+)"), _T("") },
	{15, 1, _T("Max regulation step number")		, true, 1, 1		, _T("Maximum allowed regulation step number (0-255) (firmware version >= v2.0)"), _T("") },
	
	{16, 2, _T("Off-delay TIME 0")					, false, 3, 1		, _T("Time between IGN OFF to PSW OFF impulse in Time Configuration 0 (max. 17:59:59 or Never)"), _T("[hh:mm:ss]") },
			//{17, 0, _T("FILLER")							, true, 1, 1		, _T(""), _T("") },
	{18, 2, _T("Hard-off TIME 0")					, false, 3, 1		, _T("Time Between PSW OFF to Output OFF,Hardware OFF in Time Configuration 0 (max. 17:59:59 or Never)"), _T("[hh:mm:ss]") },
			//{19, 0, _T("FILLER")							, true, 1, 1		, _T(""), _T("") },
	{20, 2, _T("Off-delay TIME 1")					, true, 3, 1		, _T("Time between IGN OFF to PSW OFF impulse in Time Configuration 1 (max. 17:59:59 or Never)"), _T("[hh:mm:ss]") },
			//{21, 0, _T("FILLER")							, true, 1, 1		, _T(""), _T("") },
	{22, 2, _T("Hard-off TIME 1")					, true, 3, 1		, _T("Time Between PSW OFF to Output OFF,Hardware OFF in Time Configuration 1 (max. 17:59:59 or Never)"), _T("[hh:mm:ss]") },
			//{23, 0, _T("FILLER")							, true, 1, 1		, _T(""), _T("") },
	{24, 2, _T("Off-delay TIME 2")					, true, 3, 1		, _T("Time between IGN OFF to PSW OFF impulse in Time Configuration 2 (max. 17:59:59 or Never)"), _T("[hh:mm:ss]") },
			//{25, 0, _T("FILLER")							, true, 1, 1		, _T(""), _T("") },
	{26, 2, _T("Hard-off TIME 2")					, true, 3, 1		, _T("Time Between PSW OFF to Output OFF,Hardware OFF in Time Configuration 2 (max. 17:59:59 or Never)"), _T("[hh:mm:ss]") },
			//{27, 0, _T("FILLER")							, true, 1, 1		, _T(""), _T("") },
	{28, 2, _T("Off-delay TIME 3")					, true, 3, 1		, _T("Time between IGN OFF to PSW OFF impulse in Time Configuration 3 (max. 17:59:59 or Never)"), _T("[hh:mm:ss]") },
			//{29, 0, _T("FILLER")							, true, 1, 1		, _T(""), _T("") },

	{32, 2, _T("Hard-off TIME 3")					, true, 3, 1		, _T("Time Between PSW OFF to Output OFF,Hardware OFF in Time Configuration 3 (max. 17:59:59 or Never)"), _T("[hh:mm:ss]") },
			//{33, 0, _T("FILLER")							, true, 1, 1		, _T(""), _T("") },
	{34, 2, _T("Off-delay TIME 4")					, true, 3, 1		, _T("Time between IGN OFF to PSW OFF impulse in Time Configuration 4 (max. 17:59:59 or Never)"), _T("[hh:mm:ss]") },
			//{35, 0, _T("FILLER")							, true, 1, 1		, _T(""), _T("") },
	{36, 2, _T("Hard-off TIME 4")					, true, 3, 1		, _T("Time Between PSW OFF to Output OFF,Hardware OFF in Time Configuration 4 (max. 17:59:59 or Never)"), _T("[hh:mm:ss]") },
			//{37, 0, _T("FILLER")							, true, 1, 1		, _T(""), _T("") },
	{38, 2, _T("Off-delay TIME 5")					, true, 3, 1		, _T("Time between IGN OFF to PSW OFF impulse in Time Configuration 5 (max. 17:59:59 or Never)"), _T("[hh:mm:ss]") },
			//{39, 0, _T("FILLER")							, true, 1, 1		, _T(""), _T("") },
	{40, 2, _T("Hard-off TIME 5")					, true, 3, 1		, _T("Time Between PSW OFF to Output OFF,Hardware OFF in Time Configuration 5 (max. 17:59:59 or Never)"), _T("[hh:mm:ss]") },
			//{41, 0, _T("FILLER")							, true, 1, 1		, _T(""), _T("") },
	{42, 2, _T("Off-delay TIME 6")					, true, 3, 1		, _T("Time between IGN OFF to PSW OFF impulse in Time Configuration 6 (max. 17:59:59 or Never)"), _T("[hh:mm:ss]") },
			//{43, 0, _T("FILLER")							, true, 1, 1		, _T(""), _T("") },
	{44, 2, _T("Hard-off TIME 6")					, true, 3, 1		, _T("Time Between PSW OFF to Output OFF,Hardware OFF in Time Configuration 6 (max. 17:59:59 or Never)"), _T("[hh:mm:ss]") },
			//{45, 0, _T("FILLER")							, true, 1, 1		, _T(""), _T("") },

	{48, 2, _T("Off-delay TIME 7")					, true, 3, 1		, _T("Time between IGN OFF to PSW OFF impulse in Time Configuration 7 (max. 17:59:59 or Never)"), _T("[hh:mm:ss]") },
			//{49, 0, _T("FILLER")							, true, 1, 1		, _T(""), _T("") },
	{50, 2, _T("Hard-off TIME 7")					, true, 3, 1		, _T("Time Between PSW OFF to Output OFF,Hardware OFF in Time Configuration 7 (max. 17:59:59 or Never)"), _T("[hh:mm:ss]") },
			//{51, 0, _T("FILLER")							, true, 1, 1		, _T(""), _T("") },

	{46, 1, _T("UPS Mode: Shutdown Time")			, true, 1, 1		, _T("After OFF impulse is sent wait \"UPS Mode: Shutdown Time\" till Output OFF,Hardware OFF"), _T("[sec]") },
	{47, 1, _T("UPS Mode: Ignition OFF time")		, true, 1, 1		, _T("If IGN is OFF for \"UPS Mode: Ignition OFF time\" time the PSU will send OFF impulse"), _T("[sec]") },

	{60, 1, _T("UPS Mode: Ignition ON")				, true, 2, 0.1558	, _T("PSU will be ON if IGN>\"UPS Mode: Ignition ON\" (and VIN>\"UPS Mode: VIn Good\")"), _T("[V]") },
	{61, 1, _T("UPS Mode: Ignition OFF")			, true, 2, 0.1558	, _T("PSU will be OFF if IGN<\"UPS Mode: Ignition OFF\" for \"UPS Mode: Ignition OFF time\" seconds"), _T("[V]") },
	{62, 1, _T("UPS Mode: VIn Good")				, true, 2, 0.1558	, _T("PSU will be ON if VIN>\"UPS Mode: VIn Good\" (and IGN>\"UPS Mode: Ignition ON\")"), _T("[V]") },
			
};

ATXMSG* HIDDcDcUsb::GetMessages()
{
	return g_memMessages;
}

double HIDDcDcUsb::GetVOut(unsigned char data)
{
//	double rpot = ((double)data) * CT_RP / (double)257 + CT_RW;
//	return (double)0.8 * ( (double)1 + CT_R1/(rpot+CT_R2));

	double rpot = ((double)data) * CT_RP / (double)257 + CT_RW;
	double voltage = (double)80 * ( (double)1 + CT_R1/(rpot+CT_R2));
	voltage = floor(voltage);
	return voltage/100;
}

unsigned char HIDDcDcUsb::GetData(double vout)
{
//	double rpot = (double)0.8 * CT_R1 / (vout - (double)0.8) - CT_R2;
//	return (unsigned char)(257 * (rpot-CT_RW) / CT_RP);
	
	double rpot = (double)0.8 * CT_R1 / (vout - (double)0.8) - CT_R2;
	double result = (257 * (rpot-CT_RW) / CT_RP);

	if (result<0) result = 0;
	if (result>255) result = 255;

	return (unsigned char)result;

/*	for (unsigned char d=0;d<256;d++)
	{
		double vtest = GetVOut(d);
		TRACE("     td=%02x vt=%f\n",d, vtest);
		if (vout >= vtest)
		{
			return d;
		}
	}
	return 0;*/
}

HIDDcDcUsb::HIDDcDcUsb(HIDDevice* hdev, int timeout):HIDInterface(hdev)
{
	if (hdev)
		TRACE( "HID device %s %s opened\n"
		, hdev->GetDescriptor()->m_sManufacturer
		, hdev->GetDescriptor()->m_sProduct);
	TRACE( "HID device could not be opened\n");
		
	m_nError = -1;
	m_pGraphics = NULL;

	m_nTimeout = timeout;
}

HIDDcDcUsb::~HIDDcDcUsb()
{
	m_nError = 0;

	m_list.lock();
	m_list.moveToHead();
	HArray* a = (HArray*)m_list.nextElement();
	while (a)
	{
		delete a;
		a = (HArray*)m_list.nextElement();
	}
	m_list.removeall();
	m_list.unlock();
}

HArray* HIDDcDcUsb::getReceivedMessage()
{
	m_list.lock();
	m_list.moveToHead();
	HArray* a = (HArray*)m_list.nextElement();
	if (a)
		m_list.removeWithNoLocking(a);
	m_list.unlock();

	return a;
}

void HIDDcDcUsb::GetAllParams()
{
	sendMessage(DCDCUSB_GET_ALL_VALUES, 0);
}

bool HIDDcDcUsb::waitForAnswer()
{
	int tmout = 0;
	while (m_nError == -1)
	{
		Sleep(A_SLEEP);
		tmout++;
		if (tmout > A_TIMEOUT) return false;
	}
	return true;
}

bool HIDDcDcUsb::sendMessage(unsigned char cType, unsigned int buflen, unsigned char* buffer, unsigned int len, ...)
{
	HArray hArray(buflen+ len + 1);
	hArray.getBuf()[0] = cType;

	va_list args;
	va_start(args, len);
	unsigned int cnt = 0;
#ifdef _WIN32	
	unsigned char i = va_arg(args, unsigned char);
#else
	unsigned char i = va_arg(args, unsigned int);
#endif
	while (cnt<len)
	{
		hArray.getBuf()[1+cnt] = i;
		cnt++;
		if (cnt < len)
#ifdef _WIN32			
		 	i = va_arg(args, unsigned char);
#else
			i = va_arg(args, unsigned int);
#endif
	}
	
	va_end(args);
	
	memcpy(hArray.getBuf()+1+len, buffer, buflen);

	m_nError = -1;
	if (Write(&hArray))
	{
		if ((cType == DCDCUSB_MEM_READ_OUT)||(cType == DCDCUSB_MEM_ERASE)||(cType == DCDCUSB_MEM_WRITE_OUT))
		{
			int tmout = 0;
			while (m_nError == -1)
			{
				Sleep(A_SLEEP);
				tmout++;
				if (tmout > A_TIMEOUT) return false;
			}
		}
		return true;
	}
	else return false;
}

bool HIDDcDcUsb::sendMessage(unsigned char cType, unsigned int len, ...)
{
	HArray hArray(len + 1);
	hArray.getBuf()[0] = cType;

	va_list args;
	va_start(args, len);
	unsigned int cnt = 0;
#ifdef _WIN32	
	unsigned char i = va_arg(args, unsigned char);
#else
	unsigned char i = va_arg(args, unsigned int);
#endif
	while (cnt<len)
	{
		hArray.getBuf()[1+cnt] = i;
		cnt++;
		if (cnt < len)
#ifdef _WIN32			
		 	i = va_arg(args, unsigned char);
#else
			i = va_arg(args, unsigned int);
#endif
	}
	
	va_end(args);

	m_nError = -1;
	if (Write(&hArray))
	{
		if ((cType == DCDCUSB_MEM_READ_OUT)||(cType == DCDCUSB_MEM_ERASE)||(cType == DCDCUSB_MEM_WRITE_OUT))
		{
			int tmout = 0;
			while (m_nError == -1)
			{
				Sleep(A_SLEEP);
				tmout++;
				if (tmout > A_TIMEOUT) return false;
			}
		}
		return true;
	}
	else return false;
}

void HIDDcDcUsb::Received(HArray* array)
{
	m_aReceived.setValue(array);

	m_list.add(new HArray(array));

	m_nError = 0;
}

void HIDDcDcUsb::Disconnected()
{
	unsigned char ch[24] = {INTERNAL_MESG, INTERNAL_MESG_DISCONNECTED,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
	m_list.add(new HArray(ch, 24));
}

void HIDDcDcUsb::connectGraph(HIDGraphics* hg)
{
	m_lockCommand.lock();
	m_pGraphics = hg;
	m_lockCommand.unlock();
}

bool HIDDcDcUsb::Write(HArray* mesg)
{
	m_lockWrite.lock();
	bool b = m_pParent->Write(mesg);
	m_lockWrite.unlock();

	return b;
}


//////////////// READ STUFF ////////////

int HIDDcDcUsb::_getReadMsg(int type)
{
	switch (type)
	{
	case TYPE_CODE_MEMORY:		return FLASH_REPORT_READ_MEMORY;
	case TYPE_EPROM_EXTERNAL:	return OUT_REPORT_EXT_EE_READ;
	case TYPE_EPROM_INTERNAL:	return OUT_REPORT_INT_EE_READ;
	case TYPE_CODE_SPLASH:		return KEYBD_REPORT_READ_MEMORY;
	}
	return 0;
}

bool HIDDcDcUsb::readFile(bool fromsocket, int type, const char* file,const unsigned long start, const unsigned long end)
{
	//if (!_isEnabled(type)) return false;//flash read permitted in both modes

	m_lockCommand.lock();
	int n = _readFile(fromsocket, type, file, start, end);
	if (n != 0)
	{
		TRACE("Error occured reading: %d (type=%d)\n", n, type);
	}
	else
	{
		TRACE("Reading succesfull: %d (type=%d)\n", n, type);
	}
	m_lockCommand.unlock();

	return (n==0);
}

int HIDDcDcUsb::_readFile(bool fromsocket, int type, const char* file,const unsigned long start, const unsigned long end)
{
	if (end<=start) return -100;

	/*int online_len = PKG_LEN_FLASH-5;//32
	if (type != TYPE_CODE_MEMORY) online_len = PKG_LEN_LCD-4;//20

	unsigned long lines = ceil( (double)(end - start) / (double)online_len );//32

	FILE* fw = fopen(file, "wt");
	if (!fw) return -1;

	fprintf(fw, ":020000040000FA\r\n");

	int tmout;
	unsigned long addr = start, oldaddr = start;
	int temp;
	while (addr < end)
	{
		if (m_pGraphics)
			m_pGraphics->UpdateStatus(fromsocket, STATUS_READ, lines, ((addr - start) / online_len) + 1);

		m_nError = -1;

		HArray read;
		if (type == TYPE_CODE_MEMORY)
		{
			temp = end - addr;
			if (temp>online_len) temp=online_len;//32
			read.setHIDPkt(_getReadMsg(type), 4, 4, addr & 0xff, (addr >> 8) & 0xff, (addr >> 16) & 0xff, temp);
		}
		else
		{
			temp = end - addr;
			if (temp>online_len) temp=online_len;//20
			read.setHIDPkt(_getReadMsg(type), 3, 3, addr & 0xff, (addr >> 8) & 0xff, temp);
		}

		m_bWriteOK = m_pParent->Write(&read);

		tmout = 0;
		while (m_nError == -1)
		{
			Sleep(A_SLEEP);
			tmout++;
			if (tmout > A_TIMEOUT)
			{
				fprintf(fw, "ERROR: timeout\r\n");
				fclose(fw);
				return -2;
			}
		}

		if (m_nError != 0)
		{
			fprintf(fw, "ERROR: device responded with %x\r\n", m_nError);
			fclose(fw);
			return m_nError;
		}

		unsigned char checksum = 0;
		if (type == TYPE_CODE_MEMORY)
		{
			fprintf(fw, ":%02X",m_aReceived.getAt(4));
			checksum += m_aReceived.getAt(4);
			fprintf(fw, "%02X",((addr >> 8) & 0xff));
			checksum += ((addr >> 8) & 0xff);
			fprintf(fw, "%02X",addr & 0xff);
			checksum += (addr & 0xff);
			fprintf(fw, "00");
			for (unsigned int i=5;i<(m_aReceived.getAt(4)+5);i++)
			{
				fprintf(fw, "%02X",m_aReceived.getAt(i));
				checksum += m_aReceived.getAt(i);
			}
			checksum = 0x01 + ~checksum;
			fprintf(fw, "%02X\r\n",checksum);

			addr += temp;//32
		}
		else
		{
			fprintf(fw, ":%02X",m_aReceived.getAt(3));
			checksum += m_aReceived.getAt(3);
			fprintf(fw, "%02X",((addr >> 8) & 0xff));
			checksum += ((addr >> 8) & 0xff);
			fprintf(fw, "%02X",addr & 0xff);
			checksum += (addr & 0xff);
			fprintf(fw, "00");
			for (unsigned int i=4;i<(m_aReceived.getAt(3)+4);i++)
			{
				fprintf(fw, "%02X",m_aReceived.getAt(i));
				checksum += m_aReceived.getAt(i);
			}
			checksum = 0x01 + ~checksum;
			fprintf(fw, "%02X\r\n",checksum);	
			
			addr += temp;//20;
		}
	}

	fprintf(fw,":00000001FF");
	fclose(fw);*/
	return 0;
}